/*
    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/cast.h>



#define VER         "0.1"
#define BUFFSZ      4096
#define PASS        "   m_Password="
#define BLACK       "BlackListPassword="
#define OZUMKEY     "pICrypt->setKe" "\x0c\x5d"


#ifndef WIN32
    #define strnicmp    strncasecmp
    #define stristr     strcasestr
#endif

#ifndef u_char
    #define u_char  unsigned char
#endif



void ozum_pwd(u_char *pwd);
void std_err(void);



int main(int argc, char *argv[]) {
    FILE    *fd;
    int     choice = 1;
    u_char  buff[BUFFSZ + 1],
            *ptr,
            *ptr1;


    setbuf(stdout, NULL);

    fputs("\n"
        "Ozum project password shower and blacklist password decoder "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\nUsage: %s <preference.ini_OR_project.env>\n"
            "\n"
            "If the file is preference.ini this tool will decode the blacklist password stored in it.\n"
            "Instead if the file is a project it will simply show the plain-text project password contained in the file, but you can simply use a text editor that is the better solution.\n"
            "\n", argv[0]);
        fputs("\n    Press RETURN to exit\n", stdout);
        fgetc(stdin);
        exit(1);
    }

    printf("\nOpening file %s\n\n", argv[1]);
    fd = fopen(argv[1], "rb");
    if(!fd) std_err();

    if(stristr(argv[1], ".ini")) choice = 0;

    while(1) {
        if(!fgets(buff, BUFFSZ, fd)) break;

        if(choice) {
            if(!strnicmp(buff, PASS, sizeof(PASS) - 1)) {
                ptr = buff + sizeof(PASS) - 1;
                if(*ptr <= 0xd) {
                    fputs("This project file isn't password protected\n", stdout);
                } else {
                    printf("Project password:   %s\n", ptr);
                }
            }
        } else {
            if(!strnicmp(buff, BLACK, sizeof(BLACK) - 1)) {
                ptr = ptr1 = buff + sizeof(BLACK) - 1;
                for(; *ptr > 0xd; ptr++);   // \r\n
                *ptr = 0;
                ozum_pwd(ptr1);
                printf("Password:   %s\n"
                    "            (attention to possible garbage data at the end of the password)\n",
                    ptr1);
            }
        }
    }

    fclose(fd);
    fputs("\n\n    Press RETURN to exit\n", stdout);
    fgetc(stdin);
    return(0);
}



void ozum_pwd(u_char *pwd) {
    int         len,
                i;
    u_char      *ptr;
    CAST_KEY    ckey;

    len = strlen(pwd) >> 3;
    CAST_set_key(&ckey, sizeof(OZUMKEY) - 1, OZUMKEY);
    ptr = pwd + (len << 3) - 8;
    while(len--) {
        CAST_ecb_encrypt(ptr, ptr, &ckey, CAST_DECRYPT);
        if(len) {
            for(i = 0; i < 8; i++) {
                ptr[i] ^= ptr[i - 8];
            }
        }
        ptr -= 8;
    }
}



void std_err(void) {
    perror("\nError");
    fputs("\n    Press RETURN to exit\n", stdout);
    fgetc(stdin);
    exit(1);
}


